#ifndef _CLIENTSIMPLEXPROPERTY_H_
#define _CLIENTSIMPLEXPROPERTY_H_

#include <Geometry/SimplexProperty.h>
#include <buildspec.h>
#include <string>
namespace GST
{
namespace Geometry
{

class GST_API_EXPORT ClientSimplexProperty : public SimplexProperty
{
protected:
	// ClientSimplexProperty() {}

public:
	virtual ~ClientSimplexProperty();

	///@name boost container members
	//@{

	/**
	 * Implement this method in derived class creating a cloned
	 * but new instance!
	 * (This is need due to the use of this abstract in ptr_vector<>.)
	 */
	virtual ClientSimplexProperty *clone() const = 0;
	//@}

	bool TypeEquals(const ClientSimplexProperty &other) const;
	bool NameEquals(const ClientSimplexProperty &other) const;
	bool operator==(const ClientSimplexProperty &other) const;
};

/**
 * called from ptr_vector.
 * @see boost\ptr_container\clone_allocator.hpp(29): template< class T > inline
 * T* new_clone( const T& r )
 */
GST_API_EXPORT ClientSimplexProperty *new_clone(
	ClientSimplexProperty const &other);

} // namespace Geometry
} // namespace GST

#endif //_CLIENTSIMPLEXPROPERTY_H_
